using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents simple security request 
	/// messages as defined in secSimpleRequest.xsd
	/// </summary>
	public abstract class SecuritySimpleRequestMessage : SecurityBaseRequestMessage
	{
		/// <summary>
		/// VistALink message XSD schema file name string. 		
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string XsdName = "secSimpleRequest.xsd";

		/// <summary>
		/// This constructor allows creating simple security 
		/// request message with predefined request type.
		/// </summary>
		/// <param name="requestType">VistALink message request type.</param>
		protected SecuritySimpleRequestMessage( string requestType )
			: base( XsdName, requestType ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="requestType">VistALink message request type.</param>
		/// <param name="sourceDoc">Source XML document.</param>
		protected SecuritySimpleRequestMessage( string requestType, XmlDocument sourceDoc )
			: base( XsdName, requestType, sourceDoc ) {}
	}
}
